/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiSource
 * 
 * Copyright (C) 2007 Philippe Milot <PhilMilot@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifndef _OXMLI_STREAMLISTENER_H_
#define _OXMLI_STREAMLISTENER_H_

// AbiWord includes
#include <ut_types.h>
#include <ut_xml.h>

// Internal includes
#include <OXMLi_Types.h>
#include <OXMLi_ListenerState.h>

// External includes
#include <list>

class OXMLi_ListenerState;

class OXMLi_StreamListener : public virtual UT_XML::Listener
{
public:
	OXMLi_StreamListener();
	virtual ~OXMLi_StreamListener();

	inline void setStatus(UT_Error sts) { m_parseStatus = sts; }
	inline UT_Error getStatus() { return m_parseStatus; }

	void setupStates(OXML_PartType type);

	virtual void startElement (const gchar* pName, const gchar** ppAtts);
	virtual void endElement (const gchar* pName);
	virtual void charData (const gchar* pBuffer, int length);

private:
	OXMLi_ElementStack* m_pElemStack;
	OXMLi_ContextVector m_context;
	std::list<OXMLi_ListenerState*> m_states;
	UT_Error m_parseStatus;

	void pushState(OXMLi_ListenerState * s);
	void popState();
	void clearStates();

	void verifyStatus();
};

#endif //_OXMLI_STREAMLISTENER_H_

