/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiSource
 * 
 * Copyright (C) 2007 Philippe Milot <PhilMilot@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#include "OXMLi_ListenerState_HdrFtr.h"
#include <cstring>
#include <ut_debugmsg.h>

OXMLi_ListenerState_HdrFtr::OXMLi_ListenerState_HdrFtr() : 
	OXMLi_ListenerState()
{

}

OXMLi_ListenerState_HdrFtr::~OXMLi_ListenerState_HdrFtr()
{
}

void OXMLi_ListenerState_HdrFtr::startElement (OXMLi_StartElementRequest * rqst)
{
	UT_return_if_fail( this->_error_if_fail(rqst != NULL) );

	if (!strcmp(rqst->pName, "hdr"))
	{
		UT_DEBUGMSG(("Starting a hdr tag.\n"));
	}
	else if (!strcmp(rqst->pName, "ftr"))
	{
		UT_DEBUGMSG(("Starting a ftr tag.\n"));
	}
}

void OXMLi_ListenerState_HdrFtr::endElement (OXMLi_EndElementRequest * rqst)
{
	UT_return_if_fail( this->_error_if_fail(rqst != NULL) );

	if (!strcmp(rqst->pName, "hdr"))
	{
		UT_DEBUGMSG(("Ending a hdr tag.\n"));
	}
	else if (!strcmp(rqst->pName, "ftr"))
	{
		UT_DEBUGMSG(("Ending a ftr tag.\n"));
	}
}

void OXMLi_ListenerState_HdrFtr::charData (OXMLi_CharDataRequest * rqst)
{
	//Nothing to do here.
}

