/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiSource
 * 
 * Copyright (C) 2007 Philippe Milot <PhilMilot@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifndef _OXML_SECTION_H_
#define _OXML_SECTION_H_

// Internal includes
#include "OXML_Types.h"
#include "OXML_Element.h"
#include "OXML_ObjectWithAttrProp.h"

// AbiWord includes
#include <ut_types.h>
#include <pd_Document.h>

// External includes
#include <string>
#include <vector>

/* \class OXML_Section
 * \brief This class represents a single section in the OpenXML data model.
 * It holds references to all its content, as well as references 
 * to all its corresponding headers and footers.
*/
class OXML_Section : public OXML_ObjectWithAttrProp
{
public:
	OXML_Section();
	OXML_Section(std::string id);
	virtual ~OXML_Section();

	inline std::string getId() { return m_id; }
	inline OXML_SectionBreakType getBreakType() { return m_breakType; }
	inline void setBreakType(OXML_SectionBreakType br) { m_breakType = br; }

	inline std::string getHeaderId(OXML_HeaderFooterType type) { return m_headerIds[type]; }
	inline std::string getFooterId(OXML_HeaderFooterType type) { return m_footerIds[type]; }
	inline void setHeaderId(std::string id, OXML_HeaderFooterType type) { m_headerIds[type] = id; }
	inline void setFooterId(std::string id, OXML_HeaderFooterType type) { m_footerIds[type] = id; }

	bool operator ==(const std::string id);
	friend bool operator ==(const OXML_SharedSection& lhs, const std::string id) { return (*lhs) == id; }

	OXML_SharedElement getElement(std::string id);
	UT_Error appendElement(OXML_SharedElement obj);
	UT_Error clearChildren();

	//! Writes the OpenXML section and all its content to a file on disk.
	/*! This method is used during the export process.
		\param path String indicating the FULL path of the file.  If the file exists, it will be overridden.
	*/
	UT_Error serialize(std::string path);
	//! Appends this section and all its content to the Abiword Piecetable.
	/*! This method is used during the import process.
		\param pDocument A valid reference to the PD_Document object.
	*/
	UT_Error addToPT(PD_Document * pDocument);

private:
	std::string m_id;
	OXML_SectionBreakType m_breakType;
	OXML_ElementVector m_children;
	std::string m_headerIds[3];
	std::string m_footerIds[3];
};

#endif //_OXML_SECTION_H_

