/* OLPC Floating Toolbar
 * Copyright (C) 2006 Marc Maurer <uwog@uwog.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#include "ev_UnixOlpcToolbar.h"

// TODO: don't hardwire this, but figure it out at runtime
#define TOOLBAR_WIDTH 480
#define TOOLBAR_HEIGHT 36
#define TOOLBAR_YPADDING 6

EV_UnixOlpcToolbar::EV_UnixOlpcToolbar(XAP_UnixApp *pUnixApp, XAP_Frame *pFrame, const char *szToolbarLayoutName, const char *szToolbarLabelSetName)
	: EV_UnixToolbar(pUnixApp, pFrame, szToolbarLayoutName, szToolbarLabelSetName),
	m_pWindow(NULL),
	m_pContainer(NULL)
{
	m_pWindow = gtk_window_new(GTK_WINDOW_POPUP);   
	gtk_widget_set_size_request(m_pWindow, TOOLBAR_WIDTH, TOOLBAR_HEIGHT);

	m_pContainer = GTK_BOX(gtk_vbox_new(false, 0));
	gtk_widget_set_size_request(GTK_WIDGET(m_pContainer), m_pWindow->allocation.width, m_pWindow->allocation.height);
	gtk_container_add(GTK_CONTAINER(m_pWindow), GTK_WIDGET(m_pContainer));

	gtk_widget_show_all(m_pWindow);
}

EV_UnixOlpcToolbar::~EV_UnixOlpcToolbar()
{
	gtk_widget_destroy(GTK_WIDGET(m_pContainer));
	gtk_widget_destroy(m_pWindow);
}

void EV_UnixOlpcToolbar::setReferenceCoords(UT_sint32 x, UT_sint32 y, UT_sint32 height)
{
	UT_DEBUGMSG(("EV_UnixOlpcToolbar::setReferenceCoords(x:%d y:%d height:%d)\n", x, y, height));
	gtk_window_move(GTK_WINDOW(m_pWindow), x - (TOOLBAR_WIDTH/2), y-TOOLBAR_HEIGHT - TOOLBAR_YPADDING);	
}

GtkBox* EV_UnixOlpcToolbar::_getContainer()
{
	return m_pContainer;
}
