/*
 * LoadBindings - Simple parser to read keybindings for AbiWord
 * Copyright (C) 2007 by Martin Sevior
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef PLUGIN_LOADBINDINGS_H
#define PLUGIN_LOADBINGINGS_H
#include "ut_string_class.h"
#include "ev_EditEventMapper.h"
#include "ev_EditEventMapper.h"
#include "ev_EditBinding.h"

class AV_View;
class FL_DocLayout;
class XAP_App;
class EV_EditMethodCallData;

class ABI_EXPORT LoadBindings
{
public:
	                         LoadBindings(EV_EditMethodCallData * d);
	                        ~LoadBindings(void);
	bool                     getNextLine(UT_String & sLine);
	void                     resetLine(void);
	bool                     process(void);
	EV_EditKeyPress          getKey(UT_String & sStr);
	EV_EditKeyPress          getNamedVKey(UT_String & sStr);
	EV_EditMouseContext      getMseContext(UT_String & sStr);
	void                     clearTokenVector(UT_GenericVector<UT_String *> & Toks);
	bool                     tokenizeString(UT_GenericVector<UT_String *> & tok, UT_String & sStr, gchar * sSplit);
private:
	XAP_App *                m_pApp;
	UT_String                m_sData;
	UT_String                m_sName;
	EV_EditBindingMap *      m_pNewMap;
	UT_uint32                m_iPos;
};

#endif /* PLUGIN_LOADBINDINGS_H */












