/*
 * AbiCollab - Code to enable the modification of remote documents.
 * Copyright (C) 2005 by Martin Sevior
 * Copyright (C) 2006 by Marc Maurer <uwog@uwog.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef ABI_COLLAB_H
#define ABI_COLLAB_H

#include <vector>
#include "ut_types.h"
#include "pt_Types.h"
#include "px_ChangeRecord.h"
#include "ut_stack.h"
#include "stdio.h"
#include "xav_Listener.h"
#include "pl_Listener.h"
#include "ut_string_class.h"
#include "ut_uuid.h"

#include <xp/AbiCollab_Packet.h>
#include <xp/AbiCollab_Import.h>
#include <xp/AbiCollab_Export.h>

class FL_DocLayout;
class PD_Document;
class UT_Stack;
class PX_ChangeRecord;
class CommandLine;
class Buddy;
class AccountHandler;

class ABI_EXPORT ChangeAdjust
{
public:
	ChangeAdjust(PT_DocPosition iDocPos, PT_DocPosition iOrigDocPos, UT_sint32 iAdjust, UT_sint32 iRev, UT_sint32 iLength, UT_sint32 iOrigRemoteSeen, const char* pDocUUID);
	virtual ~ChangeAdjust(void);
		
	PT_DocPosition			m_iDocPos;
	PT_DocPosition			m_iOrigDocPos;
	UT_sint32				m_iAdjust;
	UT_sint32				m_iCRNumber;
	UT_sint32				m_iLength;
	PT_DocPosition			m_iOrigRemoteSeen;
	char*					m_pDocUUID;
};

class ABI_EXPORT AbiCollab
{
	friend class ABI_Collab_Export;

public:
	AbiCollab(PD_Document* pDoc);
	AbiCollab(const UT_UTF8String& sSessionId, PD_Document* pDoc, const UT_UTF8String& docUUID, UT_sint32 iRev, Buddy* pControler);
	virtual ~AbiCollab();

	// collaborator management
	void								addCollaborator(Buddy* pCollaborator);
	void								removeCollaborator(Buddy* pCollaborator);
	void								removeCollaboratorsForAccount(AccountHandler* pHandler);
	const std::vector<Buddy*>&		getCollaborators() const
		{ return m_vecCollaborators; }

	// import/export management
	ABI_Collab_Import*					getImport(void)
		{ return &m_Import; }
	ABI_Collab_Export*					getExport(void)
		{ return &m_Export; }
	void								push(const UT_UTF8String& packet);
	bool								push(const UT_UTF8String& packet, const Buddy& collaborator);
	void								maskExport();
	virtual const std::vector<UT_UTF8String>&	unmaskExport();
	bool								isExportMasked(void) const
		{ return m_bExportMasked; }
	void								import(SessionPacket* pPacket, const Buddy& collaborator);
	void								addChangeAdjust(ChangeAdjust* pAdjust);

	// document management
	PD_Document*						getDocument(void) const
		{ return m_pDoc; }

	void								setClose(void)
		{ m_bCloseNow = true; }
	bool								isClose(void)
		{ return  m_bCloseNow; }

	const UT_UTF8String&				getSessionId() const
		{ return m_sId; }
	bool								isLocallyControlled() const
		{ return m_pController == NULL; }
	
	UT_sint32							getOrigDocPos() const
		{ return m_iOrigDocPos; }

	void								setOrigDocPos(UT_sint32 iOrigDocPos)
		{ m_iOrigDocPos = iOrigDocPos; }

	UT_sint32							getOrigRemoteSeen() const
		{ return m_iOrigRemoteSeen; }

	void								setOrigRemoteSeen(UT_sint32 iOrigRemoteSeen)
		{ m_iOrigRemoteSeen = iOrigRemoteSeen; }

	void								setIsReverting(bool bIsReverting)
		{ m_bIsReverting = bIsReverting; }

private:
	void								_removeCollaborator(UT_sint32 index);

	// document management
	void								_setDocument(PD_Document* pDoc);
	void								_setDocListenerId(UT_uint32 iDocListenerId)
		{ m_iDocListenerId = iDocListenerId; }

	void								_fillRemoteRev(std::string& filled_packet, const Buddy& collaborator); // HACK HACK HACK

	PD_Document *					m_pDoc;
	ABI_Collab_Import				m_Import;
	ABI_Collab_Export				m_Export;

	std::vector<Buddy*>				m_vecCollaborators;
	UT_uint32						m_iDocListenerId;
	bool							m_bExportMasked;

	UT_UTF8String					m_sId;

	Buddy*							m_pController;

	CommandLine *					m_pCommandLine;
	bool							m_bCloseNow;

	UT_sint32						m_iOrigDocPos; // HACK HACK HACK
	UT_sint32						m_iOrigRemoteSeen;
	bool							m_bIsReverting;

protected:
	std::vector<UT_UTF8String>		m_vecMaskedPackets;

};

#endif /* ABI_COLLAB_H */
